/*-----------------------------------------------------------------------------
 * Example: given a Java object of type 'JniExample',
 *          first print its fields, then modify them.
 *---------------------------------------------------------------------------*/
 
#include <iostream>
#include <exception>

#include <jni.h>
#include <stdlib.h>
#include <stdlib.h>
#include <windows.h>      // for DLL construction

#include "JniExample.h"  // generated by 'javah -jni'
#include "jni_master.h"  // JNI encapsulation

using namespace std;

JNIEXPORT void JNICALL Java_JniExample_native_1call
  (JNIEnv *env, jclass clazz, jobject obj)
{
   try {
	  // Lookup the integer field ('intField') in 'obj'
	  JNIField<jint> intField(env, obj, "intField");

	  // Lookup the static String field ('stringField') in 'obj', 
	  // then translate the Java string representation into
	  // a C++ resource of type 'const char *'.
	  JNIStringUTFChars str(env, "JniExample", "stringField");

	  // Lookup the array of integers ('intArray') in 'obj', 
	  // then translate it into a C++ resource of type 'jint *'.
	  JNIArray<jint> arr(env, obj, "intArray");

	  // Print old values
	  cout << "In native call:" << endl
		   << "  intField = " << intField
		   << ", stringField = " << str.get() << endl
		   << "  intArray[0] = " << arr[0]
		   << ", intArray[1] = " << arr[1] << endl;

	  // Set new values 
	  intField = 0;
	  arr[0] = 0;
	  arr[1] = 0;

	  JNIStaticField<jstring>(env, obj, "stringField") =
		 env->NewStringUTF("Good-bye, world!");

	  // Destructors for 'str' and 'arr' are invoked automatically
   }
   catch (std::exception &e) {
	  cerr << "Exception: " << e.what() << endl;
   }
   catch (...) {
	  cerr << "Unknown exception" << endl;
   }
}
